<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Eatery extends Model 
{

    protected $table = 'eateries';
    public $timestamps = true;

    public function User()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function CategoryFoods()
    {
        return $this->hasMany('App\Models\CategoryFood');
    }

    public function ContactInfo()
    {
        return $this->hasOne('App\Models\Contact');
    }

    public function Category()
    {
        return $this->hasOne('App\Models\Category');
    }

    public function Ratings()
    {
        return $this->hasMany('App\Models\Rating');
    }

    public function Schedules()
    {
        return $this->hasMany('App\Models\Schedule');
    }

}